clear all
capture log close
program drop _all
set more off
snapshot erase _all

cd "M:\Globalization Trends\Final Data Processing\Output Data"
*** Note: directory must be set with the correct path ending in the "Output Data" folder

*** Globalization Project Master Do File.do
*** 9/16/2016
*** Brina Seidel

*************************************
*** Set necessary graph schemes, ssc commands, etc. 
*************************************
local cd = c(pwd)
sysdir set PLUS "`cd'\..\Input Data\System Directory Files"  /*Caution: this will change the default PLUS system directory, so you will want to change it back after running this code*/
set scheme graphscheme
graph set window fontface "Calibri"
ssc install wbopendata

*************************************
*** Prepare merchandise export data
*** Output data: Merchandise Exports - Percent of World GDP.dta
*************************************
do "..\Programs\Preparing Merchandise Exports Numbers.do"

*************************************
*** Prepare foreign capital stock data
*** Output data: Foreign Capital Stock - Percent of Developing World GDP.dta
*** Output graphs: Composition of Foreign Capital Stock (Bar).png; Composition of Foreign Capital Stock (Bar).png [Fig. 3]
*************************************
do "..\Programs\Preparing Foreign Capital Stock Numbers.do"

*************************************
*** Prepare global migrant stock data
*** Output data: Global Migration - Percent of Population.dta
*************************************
do "..\Programs\Preparing Global Migration Numbers.do"

*************************************
*** Combine the following three files:
***		1. Merchandise Exports - Percent of World GDP.dta
***		2. Foreign Capital Stock - Percent of Developing World GDP.dta
***		3. Global Migration - Percent of Population.dta
*** Output data: Final Data for Trends in Globalization Graph.dta 
*** Output graph: Trends in Globalization.png [Fig. 1]
*************************************
do "..\Programs\Combining Measures of Globalization.do"

*************************************
*** Prepare merchandise and service export data
*** Output data: Merchandise and Service Exports - Percent GDP.dta
*** Output graph: Service and Merchandise Exports.png [Fig. 2]
*************************************
do "..\Programs\Preparing Merchandise and Service Export Numbers.do"

*************************************
*** Prepare data on migrant stock in US and UK
*** Output data: US and UK Migrant Stock.dta
*** Output graph: US and UK Migrant Stock.png
*************************************
do "..\Programs\Preparing US and UK Migrant Stock.do"
